/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.user;

import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.servlet.pmod.PanelModelException;
import com.ibm.hwmca.fw.settings.user.UserSettings;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;

public abstract class UserSettingsBean
extends PanelBean {
    private static final String TRACE_MASKT = "HUSTB  T";
    private static final String TRACE_MASKF = "HUSTB  F";
    private static final String TRACE_MASKD = "HUSTB  D";
    public static final String REQUEST_TYPE = "RequestType";
    public static final String UPDATE_SETTINGS = "UpdateSettings";
    public static final String GET_DEFAULTS = "GetDefaults";
    protected String DEFAULTS_BUTTON_NAME = "DefaultsButton";
    protected String RESET_BUTTON_NAME = "ResetButton";
    protected String APPLY_BUTTON_NAME = "ApplyButton";
    protected String CANCEL_BUTTON_NAME = "CancelButton";
    protected String CANCEL_ACTION_NAME = "CANCEL";
    protected String OK_BUTTON_NAME = "OKButton";

    public void panelAction(TaskActionEvent evt) {
        Trace.trace(TRACE_MASKT, "-> UserSettingsBean.panelAction()");
        String actionCommand = evt.getActionCommand();
        Trace.trace(TRACE_MASKF, "   event is " + evt);
        Trace.trace(TRACE_MASKF, "   action command is " + evt.getActionCommand());
        Trace.trace(TRACE_MASKF, "   this is " + this);
        try {
            UserTaskManager utm = (UserTaskManager)evt.getSource();
            if (actionCommand.equals(this.CANCEL_BUTTON_NAME) || actionCommand.equals(this.CANCEL_ACTION_NAME)) {
                this.handleCancelButton(utm);
            } else if (actionCommand.endsWith(this.APPLY_BUTTON_NAME)) {
                this.handleApplyButton(utm);
            } else if (actionCommand.endsWith(this.RESET_BUTTON_NAME)) {
                this.handleResetButton(utm);
            } else if (actionCommand.endsWith(this.DEFAULTS_BUTTON_NAME)) {
                this.handleDefaultsButton(utm);
            } else if (actionCommand.equals(this.OK_BUTTON_NAME)) {
                this.handleOkButton(utm);
            } else {
                Trace.trace(TRACE_MASKF, "   Error, unknown action command");
            }
        }
        catch (IllegalUserDataException illegalUserDataException) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKT, "<- UserSettingsBean.panelAction()");
    }

    private void handleOkButton(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "-> UserSettingsBean.handleOkButton()");
        Object[] dataBeans = this.getDataBeans();
        for (int i = 1; i < dataBeans.length; ++i) {
            ((UserSettingsBean)dataBeans[i]).handleApplyButton(utm);
        }
        this.sendCancelRequest(utm);
        Trace.trace(TRACE_MASKF, "<- UserSettingsBean.handleOkButton()");
    }

    private void handleCancelButton(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "-> UserSettingsBean.handleCancelButton()");
        Object[] dataBeans = this.getDataBeans();
        if (this.hasAnySettingChanged(dataBeans) && !CommonMsgApp.showDataChangedConfirmation(utm)) {
            Trace.trace(TRACE_MASKF, "   throw away user input and end");
            throw new IllegalUserDataException();
        }
        this.sendCancelRequest(utm);
        Trace.trace(TRACE_MASKF, "<- UserSettingsBean.handleCancelButton()");
    }

    private void handleResetButton(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "-> UserSettingsBean.handleResetButton()");
        this.resetUserSettings(utm);
        Trace.trace(TRACE_MASKF, "<- UserSettingsBean.handleResetButton()");
    }

    private void handleApplyButton(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "-> UserSettingsBean.handleApplyButton()");
        if (this.hasSettingsChanged()) {
            this.updateUserSettings();
            UserSettings settings = this.getUserSettings();
            if (settings != null) {
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData(REQUEST_TYPE, UPDATE_SETTINGS);
                request.setData(UPDATE_SETTINGS, settings);
                Trace.trace(TRACE_MASKF, "   sending updated settings");
                this.postTaskletRequest(request);
            }
        }
        Trace.trace(TRACE_MASKF, "<- UserSettingsBean.handleApplyButton()");
    }

    private void handleDefaultsButton(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "-> UserSettingsBean.handleDefaultsButton()");
        PanelTaskletRequest request = new PanelTaskletRequest();
        request.setData(REQUEST_TYPE, GET_DEFAULTS);
        this.postTaskletRequest(request);
        Trace.trace(TRACE_MASKF, "<- UserSettingsBean.handleDefaultsButton()");
    }

    protected void sendCancelRequest(UserTaskManager utm) {
        Trace.trace(TRACE_MASKF, "-> UserSettingsBean.sendCancelRequest()");
        PanelTaskletRequest request = new PanelTaskletRequest();
        request.setCanceled();
        this.postTaskletRequest(request);
        Trace.trace(TRACE_MASKF, "<- UserSettingsBean.sendCancelRequest()");
    }

    private boolean hasAnySettingChanged(Object[] dataBeans) {
        Trace.trace(TRACE_MASKF, "-> UserSettingsBean.hasAnySettingChanged()");
        boolean result = false;
        for (int i = 0; !result && i < dataBeans.length; ++i) {
            Trace.trace(TRACE_MASKF, "   next bean is " + dataBeans[i]);
            result = ((UserSettingsBean)dataBeans[i]).hasSettingsChanged();
        }
        Trace.trace(TRACE_MASKF, "<- UserSettingsBean.hasAnySettingChanged(), result is " + result);
        return result;
    }

    protected boolean hasSettingsChanged() {
        Trace.trace(TRACE_MASKF, "<> UserSettingsBean.hasSettingsChanged(), return false");
        return false;
    }

    protected abstract void updateUserSettings();

    protected abstract UserSettings getUserSettings();

    protected abstract void resetUserSettings(UserTaskManager var1);

    Object[] getDataBeans() {
        Object[] dataBeans;
        try {
            dataBeans = this.getPanelModel().getDataBeans();
            Trace.trace(TRACE_MASKD, "   number of beans is " + dataBeans.length);
        }
        catch (PanelModelException exc) {
            Trace.trace(TRACE_MASKF, "   getPanelModel().getDataBeans() threw exception: " + exc);
            dataBeans = new Object[]{};
        }
        return dataBeans;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
    }
}

